/*
Historique:
-----------
    Module:        demo05exo2.cpp
    Auteur:        Mohamed Lokbani
    Date cration: 11 octobre 2003
    Version:       1.05
    
    Modifications:
        11 octobre 2003 - M.Lokbani - gcc3.2 + comments
        05 octobre 1999 - M.Lokbani - nonc & correction

    Copyright (C) 2003 Universit de Montral
            Dpartement d'informatique et de Recherche Oprationnelle
            Mohamed Lokbani
    -- Tous Droits Rservs -- All Rights Reserved --

Description:
------------
    Le but de cet exercice est de vous pratiquer les fonctions membres,
    et plus particulirement les fonctions membres statiques. 
    
*/



#include <iostream>
#include <string>

using namespace std;


/* 
   Les points  mentionner:
   1) on ne peut pas trouver d'initialisation de membres dans une partie dclarative
      => On initialise un membre static
   2) une fonction static ne peut accder  des membres non static, car elle est appelable
      sans pour autant qu'il y ait d'objet cr 
   3) une fonction dont le code est directement mis dans la dclaration de la classe est inline
      sauf si le compilateur en dcide autrement (code trop long, etc)!
*/

// ceci est la dclaration (devrait apparatre dans un fichier d'entte (.h)) 
class partage { 
    int a;
    
    // ceci est une "erreur" car l'initialisation doit se faire par une instruction
    // spcifique (voir plus bas) 
    //  static int b=100;
    
    static int b;

public :
    int d;
    //  static int c=200; // erreur idem pour les mmes raisons
    static int c;

    // C'est une erreur, une fonction statique ne peut qu'accder aux membres statiques 
    // ce qui n'est pas ici le cas de a

    //  static void init(int i, int j,int k) {a=i; b=j; c=k;}
    // Enlever le membre a, sinon le dclarer static

    static void init(int j,int k) {b=j; c=k;}

    void afficher();

};

// Ceci est la dfinition de la classe
// initialisations (dans la partie dfinition (.cc))
int partage::b = 100; // voila comment on doit initialiser une variable static d'une classe
int partage::c = 200;

/*
    Remarque:
        certains compilateurs acceptent cependant l'initialisation directe dans la classe ... 
        cependant c'est hors norme, non-ansi etc. .............
        il faudra respecter l'initialisation comme celle dcrite dans dans le cours et dans cet exemple.
*/

//void partage:afficher() { // :: pas : (erreur de syntaxe)
void partage::afficher() {

    // La variable a n'est pas statique, et mieux encore, il n'a mme pas t initialise!!!! TRES DANGEUREUX!
    cout << "La variable statique a : " << a << endl;
    cout << "La variable b : " << b << endl;
    cout << "La variable statique c : " << c << endl; 
}

int main(void) {
    partage x,y;

    x.init(1,1); // il manque un argument (ou alors on corrige dans la classe, ce que nous avons fait)
    x.afficher();
    y.init(2,2); // il manque un argument (ou alors on corrige dans la classe, ce que nous avons fait) 

    y.afficher();
    x.afficher();

    partage::c++; 
    // on ne peut pas accder a un membre prive 
    // partage::a++;

    // Ne marche que parce que c est static => x.c
    cout << "La variable statique c vaut: " << partage::c << endl;
    cout << x.c << " == " << y.c << endl;

    // Ne marche pas car c'est non static => auquel d accder (de quel objet)?
    // cout << "La variable statique c vaut: " << partage::d << endl; 

    // Celle-ci non plus car elle est prive (en plus d'tre non static)
    // cout << "La variable statique a vaut: " << partage::a << endl;

    return 0;
}


/*

    constatez le danger de ne pas avoir initialise la valeur de a,
        a : 4268032

        >demo05exo2sol
                La variable statique a : 4268032
                La variable b : 1
                La variable statique c : 1
                La variable statique a : 2293664
                La variable b : 2
                La variable statique c : 2
                La variable statique a : 4268032
                La variable b : 2
                La variable statique c : 2
                La variable statique c vaut: 3
                3 == 3
        >Exit code: 0

*/



