/*
Historique:
-----------
    Module:        demo12exo2sol.h
    Auteur:        Mohamed Lokbani
    Date cration: 23 novembre 1999
    Version:       1.07
    
    Modifications:
    
        07 dcembre 2003 - M.Lokbani  - comments + gcc3.2 + MinGW/Cygwin/Linux
        11 novembre 2000 - M.Lokbani  - gcc2.95
        18 juin     2000 - M.Lokbani  - la mme chose en Perl
        12 juin     2000 - M.Lokbani  - mise  jour pour E00
        30 mars     2000 - M.Lokbani  - modification dans le destructeur
                                            au niveau de la commande system
        03 decembre 1999 - M.Lokbani  - +comments + ajout de la commande system
        24 novembre 1999 - P.Langlais - solution
        23 novembre 1999 - M.Lokbani  - l'nonc
    
    

    Copyright (C) 2003 Universit de Montral
            Dpartement d'informatique et de Recherche Oprationnelle
            Mohamed Lokbani
    -- Tous Droits Rservs -- All Rights Reserved --

    Description: Lecture d'un fichier texte, recherche d'une chane de caractres,
        et remplacement de la chane si elle existe par une autre chane de caractres.

    Une approche optimise consiste  utiliser une solution  base d'une mthode de
    recouvrement "overlap". Elle consiste  lire dans un buffer tampon de M caractres
    que N caractres, o:

        si la taille de la nouvelle chane est infrieure  la taille de la chane
         remplacer, alors pas de danger pour que N=M.

        Dans le cas contraire,

        M-N = taille de la nouvelle chane - taille chane  remplacer

    Exemple:
    
        Si le buffer est de taille M=1000 char.
        La nouvelle chane: "ouvrir la fentre", sa taille est: 17 char
        L'ancienne chane: "jours", sa taille est: 5

        Alors la taille de la chane a lire est de N = 1000 - 17 - 5 = 978 char.

        Puis on glisse la fentre de lecture sur la totalit du fichier.
        Ainsi on utilisera qu'un seul fichier pour raliser l'opration
        de recherche et remplacement.


    Nous allons vous proposer une solution terre  terre plus simple  suivre.


    La solution propose suit une approche  deux fichiers. Le premier contenant
    le texte original. Le second le rsultat aprs la procdure recherche et remplacement.

    Ainsi on ouvre le fichier original en lecture. En le parcourant, on prserve son contenu
    dans un buffer de taille donne. On recherche dans ce buffer si la chane est prsente,
    si oui on la remplace, sinon le buffer reste inchang. On crit le contenu de ce
    buffer dans le fichier de sortie.

    Avant de terminer l'excution du programme, on dtruit le fichier original, pour le
    remplacer par le fichier de sortie (rsultant), pour n'avoir qu'un fichier (pas de
    duplication).


    En Perl pour faire ce qui a t dcrit prcdemment:

        perl -i -pne 's/tempete/fausse alerte \!/' essai.txt

        Perl cherche dans le fichier essai.txt la chane tempete et la remplace par la
        chane: fausse alerte! Le travail se fait sur le mme fichier.
        
        
    Attention:
    
        On a utilise une commande system pour montrer l'interaction Unix/C++
        
            mv fichier_temporaire fichier_original


        Cette commande permet de:
        
            -1- Effacer, delete,  le "fichier_original" du disque.
        
            -2- Renommer fichier_temporaire avec le nom de fichier_original
        
        
         la fin de cette opration, il n'y aura qu'un seul fichier, celui en entre
        mais remis  jour.


        Vous allez rencontrer durant cette opration un problme avec le chemin exact
        pour arriver  la commande mv.
        
        Sous Linux ou Windows (Cygwin ou MinGW) cette commande se trouve dans:
        
        /bin/mv
        
        Ainsi sur Linux, le chemin vers /bin/mv va tre trouv sans problme sous
        la condition qu'il existe et que le path soit correctement configur.
    
        Sous Windows c'est toute une autre histoire .... Si vous compilez sous Cygwin
        avec le chemin correctement configur et sous la condition aussi que /bin/mv
        existe, la aussi aucun problme! Par contre sous MinGW prparez vos nerfs!
        Vous allez en effet obtenir l'erreur suivante:
    
        The system cannot find the path specified.

        Comment dire  un MinGW de rsoudre ce chemin? Modifier la variable d'environnement
        systme path? Toujours le mme problme  l'arrive! Que faire alors?

        
        Cygwin est systme de dveloppement trs complet ce qui n'est pas le cas de MinGW.
        Ce dernier est un mini systme utilis pour certaines oprations mais pas toutes! 
        
        En ralit sous Windows le chemin pour arriver  la commande [/bin/mv] correspond
         [C:/Program Files/Msys/bin/mv] et MinGW ne s'est pas faire cette correspondance.
        
        Donc vous devez utiliser le chemin absolu pour arriver  la commande en question.

         cause des espaces blancs dans le chemin, vous devez empaqueter ce chemin dans des
        doubles quottes:
            "C:/Program Files/Msys/bin/mv"

        Sinon vous allez avoir ...
        
            C:/Program
            
            Le chemin tant perdu aprs l'espace blanc.
        

        Comment faire alors pour avoir un programme qui marche sur les deux systmes Linux
        ou Windows (Cygwin ou MinGW)?
        
            Nous allons tester l'existence de la variable _WIN32 pour dterminer si nous sommes
            en prsence de Windows ou Linux. Cette variable est dfinie que sur un poste Windows.
            Si vous voulez distinguer entre MinGW et Cygwin, vous devez dfinir aussi une autre variable.
            
            
            
        Par ailleurs, nous vous proposons deux solutions. Une plus longue mais "simple"  comprendre,
        et une autre plus rapide. Pour cette dernire la fonction system accepte comme argument un char*
        La question qui va se poser par elle-mme : Comment faire alors pour convertir un string vers
        un char*? Nous utilisons pour cela la mthode c_str dfinie dans la classe string.

*/

#ifndef _SetR_
#define _SetR_

#ifdef _WIN32
#define BINMV "C:/Program Files/Msys/bin/mv"
#else
#define BINMV "/bin/mv"
#endif

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>

using namespace std;

// ---------------------------------------------------
// Une classe qui utilise deux fichiers (un in un out)
// ---------------------------------------------------

class SetR {

private:
    static const int taille_tampon; // taille du buffer tampon
    char *tampon; // buffer tampon
    ifstream *entree; // fichier en entre
    ofstream *sortie; // fichier en sortie
    string s; // une string pour les besoins ....
    string s_in; // le nom du fichier en entre
    string s_out; // le nom du fichier en sortie
    unsigned int i;
    
    // Note: le mot inline est ici superflu (car par dfaut)
    // Procdure de recherche et remplacement
    inline string & Remplace(char *input, char *toReplace, char *by) {
        s = input;
        for (i=0; (i=s.find(toReplace,i)) < s.size(); i++) 
            s.replace(i,strlen(toReplace),by);
        return s;
    }

public:
    // Constructeur, par dfaut nous lui avons passe, la chane  chercher
    // et la chane remplaante.
    // Cependant on peut modifier ces valeurs, voir le main.
    
    SetR(char *fichier,char *toReplace="tempete",char *by="fausse alerte !");
    
    ~SetR() {
        delete [] tampon;
        entree->close();
        sortie->close();
        
        
        // Obliger d'empaqueter le chemin s'il contient un espace blanc
        
        string sy = string("\"") + BINMV + string("\" ") + s_out + " " + s_in;
        
        // Version -1- -----------------------------------
        
        // L'appel system n'utilise qu'une variable du type char *, du coup il
        // faut faire la conversion de string vers un char *.
        
        char *sx = new char[sy.size()+1];
        for (unsigned int k=0;k<sy.size();k++) sx[k] = sy[k];
        sx[sy.size()] = '\0';

        // Commande system dfinie dans cstdlib
        
        system (sx);
        
        // On libre l'espace alloue.
        
        delete [] sx;
        
        // --------------------------- FIN Version -1- ----
        
        // Version -2- -----------------------------------
        
        // Au lieu de faire la recopie lment par lment, on peut dclarer un pointeur
        // sur le c_str de la string.

        // J'ai mis cette version en commentaire. J'ai prfr laisser la version la plus
        // simple  lire.
        
        // Juste une recopie d'adresse avec conversion vers char
        
        //    char *sx = (char *) sy.c_str();
        
        //    system (sx);
        
        // On pouvait se passer de sx ... en y incluant directement la chane dans
        // la fonction system.
        
        // --------------------------- FIN Version -2- ----
        
    
    }

};

#endif // end _SetR_


