/*

Historique:
-----------
    Module:        demo12exo3sol.cpp
    Auteur:        Mohamed Lokbani
    Date cration: 23 novembre 1999
    Version:       1.04
    
    Modifications:


        07 dcembre 2003 - M.Lokbani - comments + gcc3.2
        23 juin     2000 - M.Lokbani - mise  jour E00 gcc2.95
        30 mars     2000 - M.Lokbani - modifications des commentaires
        05 dcembre 1999 - M.Lokbani - correction mineure sur le destructeur
        30 novembre 1999 - M.Lokbani - criture du code  partir de
                                        l'ide de base dcrite dans le livre de
                                        B.Stroustrup uniquement pour la partie
                                        maptable. Le reste est une belle cuisine
                                        interne!



    Copyright (C) 2003 Universit de Montral
            Dpartement d'informatique et de Recherche Oprationnelle
            Mohamed Lokbani
    -- Tous Droits Rservs -- All Rights Reserved --

*/

#include "demo12exo3sol.h"

void StatMot::maptable() {

    map<string,int> tbl;
    
    readitems(tbl,*entree);
    
    int total =0;
    typedef map<string,int>::const_iterator CI;
    
    for (CI p=tbl.begin();p!=tbl.end();++p){
        total += p->second;
        (*sortie) << p->first << '\t' << p->second << '\n';
    }
    
    (*sortie) << "-----------------\ntotal\n";
    
    (*sortie) << "nbre_mots: " << tbl.size() << "\t nbre_occurences: " << total << '\n';
    
}

void StatMot::readitems(map<string,int>& m, ifstream& in) {
    string word;
    while(in >> word) m[word] +=1;
}


// la partie definition associee
StatMot::StatMot(char *fichier_in,char *fichier_out) {
    entree = new ifstream(fichier_in,ios::in);
    string s = fichier_out;
    if (s.size()==0){
        sortie = &cout;
    } else {
        sortie = new ofstream(fichier_out,ios::out);
    }
    if (!(*entree) || !(*sortie)) {
        cout << "problme d'ouverture de fichiers\n";
        exit(1);
    }else{
        maptable();
    }
}

// ----------------------------
// jeux de main, jeux de vilain
// ----------------------------

int main(int argc, char *argv[]) {

    switch (argc) {
        // deux arguments sur la ligne de commande: nom du programme & nom du fichier
        case 2: {  
            StatMot C(argv[1]); 
            break;
        }
        // 4 arguments sur la ligne de commande:
        // Nom du programme
        // Nom du fichier en entre
        // Nom du fichier de sortie
        case 3: {
            StatMot C(argv[1],argv[2]); 
            break;
        }
        // test par defaut .... dans le cas ou le nombre d'arguments est different
        // de 2 ou 4.
        default:
            cerr << "\tSyntaxe par dfaut: " << argv[0] << " fichier_texte " << endl;
            cerr << "\n\t\tou bien avec l'argument optionnel, comme suit:" << endl;
            cerr << "\n\t" << argv[0] << " fichier_texte fichier_de_sortie" << endl;
            break;
    }
    return 0;
}
