/*


IFT1166 -

12-novembre  -2005 v1.00              M.Lokbani  code + gcc3.4.2, +comments

contact: lokbani@iro.umontreal.ca


    Copyright (C) 2005 Universit de Montral
            Dpartement d'informatique et de Recherche Oprationnelle
            Mohamed Lokbani
    -- Tous Droits Rservs -- All Rights Reserved --


Description:

    Ce fichier dcrit l'utilisation de plusieurs fonctions permettant d'ouvrir un fichier,
    de lire le contenu d'un fichier et finalement d'crire dans un fichier.
    
    Nous avons dfini ces fonctionnalits dans 3 fonctions:

        void ouv_ferm_fic(const char* nom_fic); Dcrit toutes les mthodes connues pour ouvrir un fichier
        afin de lire son contenu ou bien afin d'y crire des donnes.
        
        
        void lire_fic(const char* nom_fic); Dcrit comment lire des donnes  partir d'un fichier.

        void ecrire_fic(const char* nom_fic); Dcrit comment crire des donnes dans un fichier.
        
    La mthode main contient 3 appels:
    
        ouv_ferm_fic: juste pour valider la fonction.
        ecrire_fic: on ouvre un fichier pour y crire un court texte.
        lire_fic: on ouvre un fichier pour y lire le court texte crit dans la 2e tape.
        
Remarques:
----------

    Toutes les mthodes dcrites en annexe 2 du tp#2, s'appliquent aussi pour un flux en lecture.
    Par exemple pour "cin.getline" on peut crire "fic.getline" sachant que "fic" est un "ifstream".
    
    
     noter que pour pouvoir manipuler des fichiers, il faut imprativement inclure un des fichiers:
    
    <ifstream> pour la lecture uniquement. ifstream: fichier en mode lecture (InputFileSTREAM)
    <ofstream> pour l'criture uniquement. ofstream: fichier en mode d'criture (OutputFileSTREAM)
    <fstream> pour la lecture et l'criture. fstream: fichier en mode lecture/criture (FileSTREAM)

*/

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

/*
    Ouverture/Fermeture d'un fichier
    

    open(fic_nom):  ouvre le fichier dont le nom est fic_nom, en utilisant
                    les options par dfaut,

    open(fic_nom,flags):    ouvre le fichier fic_nom, en utilisant les options
                            spcifies par l'argument flags,

    open(fic_nom,flags,prot):   ouvre le fichier fic_nom, en utilisant les options
                                spcifies par l'argument flags, et en modifiant,
                                grce  l'argument prot, les paramtres de protection
                                associs au fichier.

    close(): ferme le fichier

    is_open():  retourne vrai (true) si le fichier a t ouvert, sinon
                faux (false) en cas d'chec.


*/

void ouv_ferm_fic(const char* nom_fic){

    /*
        Premire manire de l'crire 
            - On dfinit une instance
            - On appelle la mthode open (pour ouvrir le fichier)
            - On ferme le fichier
    */
    
    // Fichier par dfaut en mode de lecture.
    ifstream f1;
    f1.open (nom_fic);
    f1.close();
    
    // Fichier par dfaut en mode d'criture.
    ofstream f2;
    f2.open(nom_fic);
    f2.close();
    
    // Fichier ouvert en mode de lecture et criture.
    fstream f3;
    f3.open (nom_fic,ios::in | ios::out);
    f3.close();
    
    // Fichier ouvert en mode de lecture.
    fstream f4;
    f4.open (nom_fic,ios::in);
    f4.close();

    // Fichier ouvert en mode criture.
    fstream f5;
    f5.open (nom_fic,ios::out);
    f5.close();

    /*
        Deuxime manire de l'crire 
            - On dfinit une instance et on appelle (implicitement) la mthode open.
            - On ferme le fichier
    */

    // Une seconde forme d'criture, sur une seule ligne de commande.
    ifstream f6(nom_fic);
    f6.close();

    ofstream f7(nom_fic);
    f7.close();
    
    fstream f8(nom_fic,ios::in | ios::out);
    f8.close();
    
    // Fichier ouvert en mode de lecture.
    fstream f9(nom_fic,ios::in);
    f9.close();

    // Fichier ouvert en mode criture.
    fstream f10(nom_fic,ios::out);
    f10.close();

    /* 
        On pouvait aussi crire directement le nom du fichier (dconseill)
        Par exemple, ici on veut ouvrir le fichier test.txt en mode de lecture
        uniquement.
        Il est dconseill de forcer le nom de la sorte ... mme si vous n'avez
        qu'un seul fichier  ouvrir et son nom est connu!
    */
    
    ifstream f12("test.txt");
    f12.close();


    /*
        Vrification:
        et si le fichier n'est pas prsent?
    
        Avant d'ouvrir le fichier, on teste s'il est prsent dans le rpertoire,
        sinon on sort avec un  message d'erreur.
        
        Ce test s'applique aussi aux exemples prcdents
    
    */
    
    ifstream f11(nom_fic);

    if (!f11.is_open()) {
        cerr << "ne peut pas ouvrir le fichier: " << nom_fic << "\n";
        exit (1);
    }
    f11.close();
    
}

/*
    Lire le contenu d'un fichier

    - On ouvre d'abord le fichier.
    - On teste que l'ouverture est ok.
    - On lit le contenu tant que la fin n'a pas t atteinte.
    - Si c'est le cas c'est fini, on ferme le fichier.

*/

void lire_fic(const char* nom_fic){

    ifstream fic(nom_fic);
    string entree;
    
    if (!fic.is_open()) {
        cerr << "ne peut pas ouvrir le fichier: " << nom_fic << "\n";
        exit (1);
    }
    
    // Lecture du contenu du fichier.
    // La mthode eof(): (EndOfFile i.e. Fin de Fichier) retourne vrai (true)
    // si la fin de fichier a t atteinte, sinon elle retourne faux (false).
    
    while (!fic.eof()) {
        fic >> entree;
        cout  << entree << endl;
        entree=""; // On nettoye le contenu de la chane aprs chaque lecture/criture, pour viter des doublons.
    }
    fic.close();

}

void ecrire_fic(const char* nom_fic){

    ofstream fic(nom_fic);
    
    if (!fic.is_open()) {
        cerr << "ne peut pas ouvrir le fichier: " << nom_fic << "\n";
        exit (1);
    }
    
    // criture dans le fichier.
    // Utiliser le "handler" fic  la place de "cout"
    
    fic << "Debut du fichier ...." << endl;
    fic << "Ceci est un exemple comment ecrire dans un fichier\n";
    fic << "Fin de l'exemple ... au revoir!\n";
    
    // Attention, il faudra fermer le fichier pour valider l'criture, sinon elle
    // risque d'tre perdue et vous avez crit votre texte dans le "vide"!
    
    fic.close();
}


int main() {
    const char *fic = "./fichier.txt";

    ouv_ferm_fic(fic);
    
    ecrire_fic(fic);
    lire_fic(fic);
    
    return 0;
}
